/*
 * TagTreeModel.h
 *
 *  Created on: 22.10.2009
 *      Author: stefan.detter
 */

#ifndef TAGTREEMODEL_H_
#define TAGTREEMODEL_H_

#include <QAbstractItemModel>

#include "../data/TreeItem.h"

class RootItem;
class ReaderEntry;
class Reader;


class TagTreeModel : public QAbstractItemModel
{
	Q_OBJECT
public:
	TagTreeModel(QObject* parent = 0);
	virtual ~TagTreeModel();

	QVariant 		data ( const QModelIndex &index, int role ) const;
	Qt::ItemFlags 	flags ( const QModelIndex &index ) const;
	QVariant 		headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
	QModelIndex 	index ( int row, int column, const QModelIndex &parent = QModelIndex() ) const;
	QModelIndex 	parent ( const QModelIndex &index ) const;
	int 			rowCount ( const QModelIndex &parent = QModelIndex() ) const;
	int 			columnCount ( const QModelIndex &parent = QModelIndex() ) const;

	RootItem*	rootItem() const;
	TreeItem*	selectedItem() const;

public slots:
	void readerAttached ( Reader* reader );

	void itemBeginInsertRows ( TreeItem* parent, int first, int last );
	void itemendInsertRows ( );

	void itemBeginRemoveRows ( TreeItem* parent, int first, int last );
	void itemEndRemoveRows ( );

	void itemRequestsToExpand ( TreeItem* parent );
	void itemDataChanged ( TreeItem* t, int leftCol, int rightCol );

	void itemAboutToBeRemoved ( TreeItem* t );

signals:
	void expand ( const QModelIndex & index );
	void setCurrentIndex ( const QModelIndex & index );
	void setRootIndex ( const QModelIndex & index );

	void itemClicked ( const TreeItem* t );
	void itemSetRoot ( const TreeItem* t );

public slots:
	void clicked ( const QModelIndex & index );
	void doubleClicked ( const QModelIndex & index );
	void clickedIntoFreeSpace ( );

	void restoreRootIndex();

	void clearTags();

signals:
	void restoredRootIndex();

private:
	RootItem*			m_rootItem;
	TreeItem*			m_selected;
};

#endif /* TAGTREEMODEL_H_ */
